
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `jezyki`
--

CREATE TABLE `jezyki` (
  `Jezyk` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Rodzina` tinytext CHARACTER SET utf8 COLLATE utf8_bin NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `jezyki`
--

INSERT INTO `jezyki` (`Jezyk`, `Rodzina`) VALUES
('aceh', 'austronezyjska'),
('acholi', 'nilo-saharyjska'),
('adhola', 'nilo-saharyjska'),
('adi', 'sino-tybetanska'),
('adygejski', 'abchasko-adygijska'),
('afar', 'afroazjatycka'),
('afrikaans', 'indoeuropejska'),
('aimaq', 'indoeuropejska'),
('akha', 'sino-tybetanska'),
('aklanon', 'austronezyjska'),
('albanski', 'indoeuropejska'),
('altajski', 'abchasko-adygijska'),
('alur', 'nilo-saharyjska'),
('alzacki', 'indoeuropejska'),
('ama', 'nilo-saharyjska'),
('ambonski', 'austronezyjska'),
('amharski', 'afroazjatycka'),
('angami', 'sino-tybetanska'),
('angielski', 'indoeuropejska'),
('ao', 'sino-tybetanska'),
('arabski', 'afroazjatycka'),
('aringa', 'nilo-saharyjska'),
('armenski', 'indoeuropejska'),
('assamski', 'indoeuropejska'),
('asu', 'nigero-kongijska'),
('asyryjski', 'afroazjatycka'),
('awarski', 'polnocno-wschodniokaukaska'),
('azerski', 'turecka'),
('bacama', 'afroazjatycka'),
('bahnar', 'austroazjatycka'),
('bai', 'sino-tybetanska'),
('bali', 'austronezyjska'),
('bandzarski', 'austronezyjska'),
('bangka', 'austronezyjska'),
('basasemawa', 'austronezyjska'),
('baskijski', 'jezyk izolowany'),
('baszkirski', 'turecka'),
('bata', 'afroazjatycka'),
('batakangkola', 'austronezyjska'),
('batakdairi', 'austronezyjska'),
('batakkaro', 'austronezyjska'),
('batakmandailing', 'austronezyjska'),
('bataksimalungun', 'austronezyjska'),
('bataktoba', 'austronezyjska'),
('bedawiyet', 'afroazjatycka'),
('beja', 'afroazjatycka'),
('beludzi', 'indoeuropejska'),
('bemba', 'nigero-kongijska'),
('bembe', 'nigero-kongijska'),
('bena', 'nigero-kongijska'),
('bengalski', 'indoeuropejska'),
('berta', 'nilo-saharyjska'),
('betawi', 'austronezyjska'),
('bhili', 'indoeuropejska'),
('bialoruski', 'indoeuropejska'),
('bikol', 'austronezyjska'),
('bima', 'austronezyjska'),
('birmanski', 'sino-tybetanska'),
('blang', 'austroazjatycka'),
('bodo', 'sino-tybetanska'),
('borana', 'afroazjatycka'),
('brahui', 'drawidyjska'),
('bretonski', 'indoeuropejska'),
('budu', 'nigero-kongijska'),
('bugis', 'austronezyjska'),
('bulgarski', 'indoeuropejska'),
('buriacki', 'mongolska'),
('buyei', 'dajska'),
('caolan', 'dajska'),
('cebuano', 'austronezyjska'),
('ch\'ol', 'majanska'),
('chaldejski', 'afroazjatycka'),
('cham', 'austronezyjska'),
('chavacano', 'indoeuropejska'),
('chidigo', 'nigero-kongijska'),
('chiduruma', 'nigero-kongijska'),
('chiga', 'nigero-kongijska'),
('chin', 'sino-tybetanska'),
('chinantec', 'otomang'),
('chokwe', 'nigero-kongijska'),
('coorgi', 'drawidyjska'),
('czeczenski', 'polnocno-wschodniokaukaska'),
('czuwaski', 'turecka'),
('dargwa', 'polnocno-wschodniokaukaska'),
('dari', 'indoeuropejska'),
('daur', 'mongolska'),
('dawida', 'nigero-kongijska'),
('dholuo', 'nilo-saharyjska'),
('dimasa', 'sino-tybetanska'),
('dogri', 'indoeuropejska'),
('domari', 'indoeuropejska'),
('dongxiang', 'mongolska'),
('edo', 'nigero-kongijska'),
('ekegusii', 'nigero-kongijska'),
('fipa', 'nigero-kongijska'),
('francuski', 'indoeuropejska'),
('friulski', 'indoeuropejska'),
('fula', 'nigero-kongijska'),
('fuliiru', 'nigero-kongijska'),
('fumbira', 'nigero-kongijska'),
('fur', 'nilo-saharyjska'),
('galicyjski', 'indoeuropejska'),
('gamo', 'afroazjatycka'),
('ganda', 'nigero-kongijska'),
('garo', 'sino-tybetanska'),
('gayo', 'austronezyjska'),
('gedeo', 'afroazjatycka'),
('gikuyu', 'nigero-kongijska'),
('gilaki', 'indoeuropejska'),
('gogo', 'nigero-kongijska'),
('gondi', 'drawidyjska'),
('gorontalo', 'austronezyjska'),
('grecki', 'indoeuropejska'),
('guarani', 'tupi'),
('gudzaracki', 'indoeuropejska'),
('gungu', 'nigero-kongijska'),
('gurage', 'afroazjatycka'),
('gurani', 'indoeuropejska'),
('gwere', 'nigero-kongijska'),
('ha', 'nigero-kongijska'),
('hadiyya', 'afroazjatycka'),
('hakka', 'hmong-mien'),
('halabi', 'indoeuropejska'),
('hangaza', 'nigero-kongijska'),
('hani', 'sino-tybetanska'),
('hausa', 'afroazjatycka'),
('haya', 'nigero-kongijska'),
('hazaragi', 'indoeuropejska'),
('hebrajski', 'afroazjatycka'),
('hehe', 'nigero-kongijska'),
('hiligaynon', 'austronezyjska'),
('hindi', 'indoeuropejska'),
('hiszpanski', 'indoeuropejska'),
('hlai', 'dajska'),
('hmong', 'hmong-mien'),
('ho', 'austroazjatycka'),
('hokkien', 'austronezyjska'),
('holenderski', 'indoeuropejska'),
('huastec', 'majanska'),
('ibanag', 'austronezyjska'),
('ibibio', 'nigero-kongijska'),
('idakho', 'nigero-kongijska'),
('igbo', 'nigero-kongijska'),
('ijaw', 'nigero-kongijska'),
('ilocano', 'austronezyjska'),
('indonezyjski', 'austronezyjska'),
('inguski', 'polnocno-wschodniokaukaska'),
('iraqw', 'afroazjatycka'),
('izere', 'nigero-kongijska'),
('jambi', 'austronezyjska'),
('japonski', 'jezyk izolowany'),
('jarai', 'austronezyjska'),
('jawajski', 'austronezyjska'),
('jidysz', 'indoeuropejska'),
('jingpo', 'sino-tybetanska'),
('jinpgho', 'sino-tybetanska'),
('jita', 'nigero-kongijska'),
('kabardyjski', 'abchasko-adygijska'),
('kabyle', 'afroazjatycka'),
('kafa', 'afroazjatycka'),
('kagulu', 'nigero-kongijska'),
('kakwa', 'nilo-saharyjska'),
('kam', 'dajska'),
('kamba', 'nigero-kongijska'),
('kannada', 'drawidyjska'),
('kantonski', 'sino-tybetanska'),
('kanuri', 'nilo-saharyjska'),
('kanyok', 'nigero-kongijska'),
('kapampangan', 'austronezyjska'),
('karaczajsko-balkarski', 'turecka'),
('karbi', 'sino-tybetanska'),
('karen', 'sino-tybetanska'),
('kaszmirski', 'indoeuropejska'),
('kaszubski', 'indoeuropejska'),
('katalonski', 'indoeuropejska'),
('kayah', 'sino-tybetanska'),
('kayan', 'sino-tybetanska'),
('kazakh', 'turecka'),
('keczua', 'keczua'),
('kele', 'nigero-kongijska'),
('kenye', 'nigero-kongijska'),
('kerewe', 'nigero-kongijska'),
('khammuang', 'dajska'),
('khandeshi', 'indoeuropejska'),
('kharia', 'austroazjatycka'),
('khasi', 'austroazjatycka'),
('khmerski', 'austroazjatycka'),
('khun', 'dajska'),
('kiembu', 'nigero-kongijska'),
('kigiryama', 'nigero-kongijska'),
('kimiiru', 'nigero-kongijska'),
('kimmun', 'hmong-mien'),
('kinaray-a', 'austronezyjska'),
('kinga', 'nigero-kongijska'),
('kinyarwanda', 'nigero-kongijska'),
('kipsigis', 'nilo-saharyjska'),
('kirgiski', 'turecka'),
('kisan', 'drawidyjska'),
('kitharaka', 'nigero-kongijska'),
('kituba', 'nigero-kongijska'),
('koho', 'austroazjatycka'),
('kolami', 'drawidyjska'),
('komering', 'austronezyjska'),
('komi', 'uralska'),
('konkani', 'indoeuropejska'),
('konyak', 'sino-tybetanska'),
('konzo', 'nigero-kongijska'),
('koongo', 'nigero-kongijska'),
('koreanski', 'jezyk izolowany'),
('korku', 'austroazjatycka'),
('koya', 'drawidyjska'),
('kri', 'algijska'),
('kui', 'drawidyjska'),
('kumam', 'nilo-saharyjska'),
('kumyk', 'turecka'),
('kupsapiiny', 'nilo-saharyjska'),
('kurdyjski', 'indoeuropejska'),
('kuria', 'nigero-kongijska'),
('kurukh', 'drawidyjska'),
('kuvi', 'drawidyjska'),
('kuy', 'austroazjatycka'),
('kwaya', 'nigero-kongijska'),
('ladakhi', 'sino-tybetanska'),
('lahu', 'sino-tybetanska'),
('lak', 'polnocno-wschodniokaukaska'),
('langi', 'nigero-kongijska'),
('lango', 'nilo-saharyjska'),
('lao', 'dajska'),
('laotanski', 'dajska'),
('lega-shabunda', 'nigero-kongijska'),
('lewotobi', 'austronezyjska'),
('lezgi', 'polnocno-wschodniokaukaska'),
('lingala', 'nigero-kongijska'),
('lisu', 'sino-tybetanska'),
('logo', 'nigero-kongijska'),
('lotha', 'sino-tybetanska'),
('luba-kasai', 'nigero-kongijska'),
('luba-katanga', 'nigero-kongijska'),
('lubukusu', 'nigero-kongijska'),
('lugbara', 'nilo-saharyjska'),
('luguru', 'nigero-kongijska'),
('lukabaras', 'nigero-kongijska'),
('lulogooli', 'nigero-kongijska'),
('luo', 'nilo-saharyjska'),
('luri', 'indoeuropejska'),
('lutachoni', 'nigero-kongijska'),
('ma\'di', 'nilo-saharyjska'),
('maasai', 'nilo-saharyjska'),
('macedonski', 'indoeuropejska'),
('machame', 'nigero-kongijska'),
('madurese', 'austronezyjska'),
('maguindanao', 'austronezyjska'),
('maithili', 'indoeuropejska'),
('makassarese', 'austronezyjska'),
('makhuwa-meetto', 'nigero-kongijska'),
('makonde', 'nigero-kongijska'),
('malayalam', 'drawidyjska'),
('malto', 'drawidyjska'),
('mambwe-lungu', 'nigero-kongijska'),
('mandarynski', 'sino-tybetanska'),
('mangbetu', 'nigero-kongijska'),
('manggarai', 'austronezyjska'),
('maonan', 'dajska'),
('mapuche', 'jezyk izolowany'),
('maranao', 'austronezyjska'),
('marathi', 'indoeuropejska'),
('markweeta', 'nilo-saharyjska'),
('maryjski', 'uralska'),
('masaaba', 'nigero-kongijska'),
('masalit', 'nilo-saharyjska'),
('masbateno', 'austronezyjska'),
('matengo', 'nigero-kongijska'),
('maya', 'majanska'),
('mayogo', 'nigero-kongijska'),
('mazahua', 'otomang'),
('mazatec', 'otomang'),
('mbadja', 'nigero-kongijska'),
('meitei', 'sino-tybetanska'),
('mien', 'hmong-mien'),
('minangkabau', 'austronezyjska'),
('minhasan', 'austronezyjska'),
('minnan', 'sino-tybetanska'),
('mishing', 'sino-tybetanska'),
('mixe', 'jezyk izolowany'),
('mixtec', 'otomang'),
('mizo', 'sino-tybetanska'),
('mochi', 'nigero-kongijska'),
('molukanski', 'austronezyjska'),
('mon', 'austroazjatycka'),
('mongo-nkundu', 'nigero-kongijska'),
('mongolski', 'mongolska'),
('mongondow', 'austronezyjska'),
('monguor', 'mongolska'),
('mulam', 'dajska'),
('muna', 'austronezyjska'),
('munda', 'austroazjatycka'),
('mundari', 'austroazjatycka'),
('muong', 'austroazjatycka'),
('musi', 'austronezyjska'),
('mwera', 'nigero-kongijska'),
('nahuatl', 'uto-aztecka'),
('nande', 'nigero-kongijska'),
('nandi', 'nilo-saharyjska'),
('nashi', 'sino-tybetanska'),
('navajo', 'na-dene'),
('ndali', 'nigero-kongijska'),
('ndebele', 'nigero-kongijska'),
('ndendule', 'nigero-kongijska'),
('nepalski', 'indoeuropejska'),
('ng\'akarimojong', 'nilo-saharyjska'),
('ngajudayak', 'austronezyjska'),
('ngaw', 'dajska'),
('ngbaka', 'nigero-kongijska'),
('ngbandi', 'nigero-kongijska'),
('ngingo', 'nigero-kongijska'),
('ngiti', 'nigero-kongijska'),
('ngoni', 'nigero-kongijska'),
('ngulu', 'nigero-kongijska'),
('nias', 'austronezyjska'),
('niemiecki', 'indoeuropejska'),
('nilamba', 'nigero-kongijska'),
('nissi', 'sino-tybetanska'),
('nobiin', 'nilo-saharyjska'),
('nung', 'dajska'),
('nyakyusa-ngonde', 'nigero-kongijska'),
('nyala', 'nigero-kongijska'),
('nyambo', 'nigero-kongijska'),
('nyamwezi', 'nigero-kongijska'),
('nyankore', 'nigero-kongijska'),
('nyaturu', 'nigero-kongijska'),
('nyiha', 'nigero-kongijska'),
('nyole', 'nilo-saharyjska'),
('nyoro', 'nigero-kongijska'),
('odia', 'indoeuropejska'),
('okcytanski', 'indoeuropejska'),
('okinawski', 'jezyk izolowany'),
('olukhayo', 'nigero-kongijska'),
('olumarachi', 'nigero-kongijska'),
('olumarama', 'nigero-kongijska'),
('olunyole', 'nigero-kongijska'),
('olusamia', 'nigero-kongijska'),
('olushisa', 'nigero-kongijska'),
('olutsotso', 'nigero-kongijska'),
('oluwanga', 'nigero-kongijska'),
('oromo', 'afroazjatycka'),
('osing', 'austronezyjska'),
('ossetic', 'indoeuropejska'),
('otomi', 'otomang'),
('pa\'o', 'sino-tybetanska'),
('paktai', 'dajska'),
('palaung', 'austroazjatycka'),
('pangasinan', 'austronezyjska'),
('pashai', 'indoeuropejska'),
('paszto', 'indoeuropejska'),
('pendzabski', 'indoeuropejska'),
('perski', 'indoeuropejska'),
('phende', 'nigero-kongijska'),
('phom', 'sino-tybetanska'),
('phuthai', 'dajska'),
('pogolo', 'nigero-kongijska'),
('pokoot', 'nilo-saharyjska'),
('polski', 'indoeuropejska'),
('portugalski', 'indoeuropejska'),
('purepecha', 'jezyk izolowany'),
('qiang', 'sino-tybetanska'),
('rabha', 'sino-tybetanska'),
('rade', 'austronezyjska'),
('rakhine', 'sino-tybetanska'),
('rejang', 'austronezyjska'),
('roglai', 'austronezyjska'),
('rohingya', 'indoeuropejska'),
('romski', 'indoeuropejska'),
('rosyjski', 'indoeuropejska'),
('rumunski', 'indoeuropejska'),
('ruund', 'nigero-kongijska'),
('saamia', 'nigero-kongijska'),
('sabaot', 'nilo-saharyjska'),
('safwa', 'nigero-kongijska'),
('sagalla', 'nigero-kongijska'),
('salar', 'turecka'),
('sanga', 'nigero-kongijska'),
('santali', 'austroazjatycka'),
('saraiki', 'indoeuropejska'),
('sasak', 'austronezyjska'),
('savara', 'austroazjatycka'),
('sedang', 'austroazjatycka'),
('sema', 'sino-tybetanska'),
('serbsko-chorwacki', 'indoeuropejska'),
('sesotho', 'nigero-kongijska'),
('shambala', 'nigero-kongijska'),
('shan', 'dajska'),
('shi', 'nigero-kongijska'),
('shubi', 'nigero-kongijska'),
('sidamo', 'afroazjatycka'),
('sindhi', 'indoeuropejska'),
('soga', 'nigero-kongijska'),
('somalijski', 'afroazjatycka'),
('songe', 'nigero-kongijska'),
('sotho', 'nigero-kongijska'),
('suahili', 'nigero-kongijska'),
('suazi', 'nigero-kongijska'),
('suba', 'nigero-kongijska'),
('sui', 'dajska'),
('sukuma', 'nigero-kongijska'),
('sumbwa', 'nigero-kongijska'),
('sundanese', 'austronezyjska'),
('surigaonon', 'austronezyjska'),
('taabwa', 'nigero-kongijska'),
('tabasaran', 'polnocno-wschodniokaukaska'),
('tachawit', 'afroazjatycka'),
('tachelhit', 'afroazjatycka'),
('tae', 'austronezyjska'),
('tagalog', 'austronezyjska'),
('taidaeng', 'dajska'),
('taidam', 'dajska'),
('taidon', 'dajska'),
('tajski', 'dajska'),
('talinga-bwisi', 'nigero-kongijska'),
('tamazight', 'afroazjatycka'),
('tamilski', 'drawidyjska'),
('tangkhul', 'sino-tybetanska'),
('tarift', 'afroazjatycka'),
('tatarski', 'turecka'),
('tausug', 'austronezyjska'),
('tavoyan', 'sino-tybetanska'),
('tay', 'dajska'),
('telugu', 'drawidyjska'),
('tembo', 'nigero-kongijska'),
('teso', 'nilo-saharyjska'),
('tetela', 'nigero-kongijska'),
('tetum', 'austronezyjska'),
('thado', 'sino-tybetanska'),
('thai', 'dajska'),
('thur', 'nilo-saharyjska'),
('tibetan', 'sino-tybetanska'),
('tigrinya', 'afroazjatycka'),
('tiv', 'nigero-kongijska'),
('tlapanec', 'otomang'),
('tolaki', 'austronezyjska'),
('tooro', 'nigero-kongijska'),
('toraja-sa\'dan', 'austronezyjska'),
('totonac', 'jezyk izolowany'),
('tripuri', 'sino-tybetanska'),
('tseltal', 'majanska'),
('tsonga', 'nigero-kongijska'),
('tsotsil', 'majanska'),
('tswana', 'nigero-kongijska'),
('tujia', 'sino-tybetanska'),
('tulu', 'drawidyjska'),
('turecki', 'turecka'),
('turkana', 'nilo-saharyjska'),
('turkmenski', 'turecka'),
('tuwinski', 'turecka'),
('uabmeto', 'austronezyjska'),
('ujgurski', 'turecka'),
('ukrainski', 'indoeuropejska'),
('urdu', 'indoeuropejska'),
('urum', 'turecka'),
('uzbecki', 'turecka'),
('va', 'austroazjatycka'),
('venda', 'nigero-kongijska'),
('vunjo', 'nigero-kongijska'),
('wa', 'austroazjatycka'),
('walijski', 'indoeuropejska'),
('waray-waray', 'austronezyjska'),
('wegierski', 'uralska'),
('wietnamski', 'austroazjatycka'),
('wloski', 'indoeuropejska'),
('wolaytta', 'afroazjatycka'),
('xhosa', 'nigero-kongijska'),
('xibe', 'tungusko-mandzurska'),
('yaka', 'nigero-kongijska'),
('yakan', 'austronezyjska'),
('yao', 'nigero-kongijska'),
('yawi', 'austronezyjska'),
('yi', 'sino-tybetanska'),
('yombe', 'nigero-kongijska'),
('yoruba', 'nigero-kongijska'),
('zaghawa', 'nilo-saharyjska'),
('zanaki', 'nigero-kongijska'),
('zande', 'nigero-kongijska'),
('zapotec', 'otomang'),
('zazaki', 'indoeuropejska'),
('zhuang', 'dajska'),
('zigula', 'nigero-kongijska'),
('zinza', 'nigero-kongijska'),
('zulu', 'nigero-kongijska');

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `panstwa`
--

CREATE TABLE `panstwa` (
  `Panstwo` varchar(50) NOT NULL,
  `Kontynent` tinytext CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Populacja` float NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `panstwa`
--

INSERT INTO `panstwa` (`Panstwo`, `Kontynent`, `Populacja`) VALUES
('Afganistan', 'Azja', 32.5),
('Algieria', 'Afryka', 39.7),
('Argentyna', 'Ameryka Poludniowa', 43.4),
('Bangladesz', 'Azja', 161),
('Birma', 'Azja', 51.4),
('Brazylia', 'Ameryka Poludniowa', 207.8),
('Chiny', 'Azja', 1367),
('DRK', 'Afryka', 77.3),
('Egipt', 'Afryka', 91.5),
('Etiopia', 'Afryka', 99.4),
('Filipiny', 'Azja', 100.7),
('Francja', 'Europa', 64.4),
('Hiszpania', 'Europa', 46.1),
('Indie', 'Azja', 1311.1),
('Indonezja', 'Azja', 257.6),
('Irak', 'Azja', 36.4),
('Iran', 'Azja', 79.1),
('Japonia', 'Azja', 126.6),
('Kanada', 'Ameryka Polnocna', 35.9),
('Kenia', 'Afryka', 46.1),
('Kolumbia', 'Ameryka Poludniowa', 48.2),
('Korea Poludniowa', 'Azja', 50.3),
('Maroko', 'Afryka', 34.4),
('Meksyk', 'Ameryka Polnocna', 127),
('Niemcy', 'Europa', 80.7),
('Nigeria', 'Afryka', 182.2),
('Pakistan', 'Azja', 188.9),
('Polska', 'Europa', 38.6),
('Poludniowa Afryka', 'Afryka', 54.5),
('Rosja', 'Europa', 143.5),
('Sudan', 'Afryka', 40.2),
('Tajlandia', 'Azja', 68),
('Tanzania', 'Afryka', 53.5),
('Turcja', 'Azja', 78.7),
('Uganda', 'Afryka', 39),
('Ukraina', 'Europa', 44.8),
('USA', 'Ameryka Polnocna', 321.8),
('Wielka Brytania', 'Europa', 64.7),
('Wietnam', 'Azja', 93.4),
('Wlochy', 'Europa', 59.8);

-- --------------------------------------------------------

--
-- Struktura tabeli dla tabeli `uzytkownicy`
--

CREATE TABLE `uzytkownicy` (
  `Id` int(11) NOT NULL,
  `Panstwo` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Jezyk` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Uzytkownicy` float NOT NULL,
  `Urzedowy` tinytext CHARACTER SET utf8 COLLATE utf8_bin NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Zrzut danych tabeli `uzytkownicy`
--

INSERT INTO `uzytkownicy` (`Id`, `Panstwo`, `Jezyk`, `Uzytkownicy`, `Urzedowy`) VALUES
(1, 'Chiny', 'mandarynski', 1212, 'tak'),
(2, 'Indie', 'hindi', 422, 'tak'),
(3, 'USA', 'angielski', 255, 'tak'),
(4, 'Brazylia', 'portugalski', 202, 'tak'),
(5, 'Bangladesz', 'bengalski', 157.9, 'tak'),
(6, 'Japonia', 'japonski', 125, 'tak'),
(7, 'Rosja', 'rosyjski', 119, 'tak'),
(8, 'Meksyk', 'hiszpanski', 118, 'tak'),
(9, 'Egipt', 'arabski', 89, 'tak'),
(10, 'Indonezja', 'jawajski', 84.3, 'nie'),
(11, 'Indie', 'bengalski', 83.4, 'nie'),
(12, 'Pakistan', 'pendzabski', 76.4, 'nie'),
(13, 'Indie', 'telugu', 74, 'nie'),
(14, 'Chiny', 'kantonski', 72.9, 'nie'),
(15, 'Indie', 'marathi', 71.9, 'nie'),
(16, 'Niemcy', 'niemiecki', 69.8, 'tak'),
(17, 'Wietnam', 'wietnamski', 65.8, 'tak'),
(18, 'Turcja', 'turecki', 64.9, 'tak'),
(19, 'Indie', 'tamilski', 60.8, 'nie'),
(20, 'Wielka Brytania', 'angielski', 59.8, 'tak'),
(21, 'Francja', 'francuski', 59.6, 'tak'),
(22, 'Wlochy', 'wloski', 55, 'tak'),
(23, 'Indie', 'urdu', 51.5, 'nie'),
(24, 'Korea Poludniowa', 'koreanski', 48.4, 'tak'),
(25, 'Kolumbia', 'hiszpanski', 47.5, 'tak'),
(26, 'Indie', 'gudzaracki', 46.1, 'nie'),
(27, 'Indonezja', 'sundanese', 42, 'nie'),
(28, 'USA', 'hiszpanski', 41.5, 'nie'),
(29, 'Iran', 'perski', 39.8, 'tak'),
(30, 'Argentyna', 'hiszpanski', 39, 'tak'),
(31, 'Indie', 'kannada', 37.9, 'nie'),
(32, 'Polska', 'polski', 37.8, 'tak'),
(33, 'Etiopia', 'oromo', 35.3, 'nie'),
(34, 'Hiszpania', 'hiszpanski', 34.1, 'tak'),
(35, 'Indie', 'malayalam', 33.1, 'nie'),
(36, 'Indie', 'odia', 33, 'nie'),
(37, 'Birma', 'birmanski', 32.9, 'tak'),
(38, 'Ukraina', 'ukrainski', 32, 'tak'),
(39, 'Etiopia', 'amharski', 30.6, 'tak'),
(40, 'Indie', 'pendzabski', 29.1, 'nie'),
(41, 'Algieria', 'arabski', 28.7, 'tak'),
(42, 'Pakistan', 'paszto', 26.7, 'nie'),
(43, 'Sudan', 'arabski', 26.7, 'tak'),
(44, 'Filipiny', 'tagalog', 26.4, 'tak'),
(45, 'Maroko', 'arabski', 25, 'tak'),
(46, 'Pakistan', 'sindhi', 24.4, 'nie'),
(47, 'Nigeria', 'igbo', 24, 'nie'),
(48, 'Indonezja', 'indonezyjski', 23.1, 'tak'),
(49, 'Irak', 'arabski', 22.4, 'tak'),
(50, 'Filipiny', 'cebuano', 21.3, 'nie'),
(51, 'Tajlandia', 'tajski', 20, 'tak'),
(52, 'Kanada', 'angielski', 19.4, 'tak'),
(53, 'Nigeria', 'yoruba', 18.9, 'nie'),
(54, 'Nigeria', 'hausa', 18.5, 'nie'),
(55, 'Pakistan', 'saraiki', 18, 'nie'),
(56, 'Chiny', 'zhuang', 16.9, 'nie'),
(57, 'Afganistan', 'dari', 16.2, 'tak'),
(58, 'Tajlandia', 'lao', 15.2, 'nie'),
(59, 'Tanzania', 'suahili', 15, 'tak'),
(60, 'Indonezja', 'madurese', 13.6, 'nie'),
(61, 'Iran', 'azerski', 13.5, 'nie'),
(62, 'Indie', 'assamski', 13.2, 'nie'),
(63, 'Pakistan', 'urdu', 13.1, 'tak'),
(64, 'Indie', 'maithili', 12.2, 'nie'),
(65, 'Poludniowa Afryka', 'zulu', 11.6, 'tak'),
(66, 'Chiny', 'ujgurski', 10.1, 'nie'),
(67, 'Indie', 'bhili', 9.6, 'nie'),
(68, 'Chiny', 'hmong', 9.4, 'nie'),
(69, 'Afganistan', 'paszto', 8.7, 'tak'),
(70, 'Chiny', 'yi', 8.7, 'nie'),
(71, 'Ukraina', 'rosyjski', 8.3, 'nie'),
(72, 'Poludniowa Afryka', 'xhosa', 8.2, 'tak'),
(73, 'Kanada', 'francuski', 8.1, 'tak'),
(74, 'Turcja', 'kurdyjski', 8.1, 'nie'),
(75, 'Algieria', 'kabyle', 8, 'nie'),
(76, 'Filipiny', 'ilocano', 7.8, 'nie'),
(77, 'Hiszpania', 'katalonski', 7.8, 'nie'),
(78, 'Iran', 'kurdyjski', 7.5, 'nie'),
(79, 'Irak', 'kurdyjski', 7.4, 'tak'),
(80, 'Tanzania', 'sukuma', 7.3, 'nie'),
(81, 'Filipiny', 'hiligaynon', 7, 'nie'),
(82, 'Poludniowa Afryka', 'afrikaans', 6.9, 'tak'),
(83, 'Kenia', 'gikuyu', 6.6, 'nie'),
(84, 'Etiopia', 'somalijski', 6.5, 'nie'),
(85, 'Indie', 'santali', 6.5, 'nie'),
(86, 'Chiny', 'tibetan', 6.3, 'nie'),
(87, 'DRK', 'luba-kasai', 6.3, 'tak'),
(88, 'Etiopia', 'tigrinya', 6.2, 'nie'),
(89, 'Pakistan', 'beludzi', 6.2, 'nie'),
(90, 'Chiny', 'mongolski', 6, 'nie'),
(91, 'Tajlandia', 'khammuang', 6, 'nie'),
(92, 'Uganda', 'ganda', 5.6, 'nie'),
(93, 'Indie', 'kaszmirski', 5.5, 'nie'),
(94, 'Indonezja', 'minangkabau', 5.5, 'nie'),
(95, 'Iran', 'gilaki', 5.3, 'nie'),
(96, 'Poludniowa Afryka', 'angielski', 4.9, 'tak'),
(97, 'Poludniowa Afryka', 'sotho', 4.6, 'tak'),
(98, 'Iran', 'luri', 4.5, 'nie'),
(99, 'Tajlandia', 'paktai', 4.5, 'nie'),
(100, 'Rosja', 'tatarski', 4.3, 'nie'),
(101, 'DRK', 'kituba', 4.2, 'tak'),
(102, 'Poludniowa Afryka', 'tswana', 4.1, 'tak'),
(103, 'Kenia', 'dholuo', 4, 'nie'),
(104, 'Nigeria', 'angielski', 4, 'tak'),
(105, 'Indonezja', 'musi', 3.9, 'nie'),
(106, 'Kenia', 'kamba', 3.9, 'nie'),
(107, 'Maroko', 'tachelhit', 3.9, 'nie'),
(108, 'Indonezja', 'minhasan', 3.8, 'nie'),
(109, 'Poludniowa Afryka', 'sesotho', 3.8, 'tak'),
(110, 'Indonezja', 'aceh', 3.5, 'nie'),
(111, 'Indonezja', 'bandzarski', 3.5, 'nie'),
(112, 'Indonezja', 'bugis', 3.5, 'nie'),
(113, 'Uganda', 'nyankore', 3.4, 'nie'),
(114, 'Indonezja', 'bali', 3.3, 'nie'),
(115, 'Birma', 'shan', 3.2, 'nie'),
(116, 'Hiszpania', 'galicyjski', 3.2, 'nie'),
(117, 'Filipiny', 'waray-waray', 3.1, 'nie'),
(118, 'DRK', 'koongo', 3, 'nie'),
(119, 'Nigeria', 'kanuri', 3, 'nie'),
(120, 'Uganda', 'soga', 3, 'nie'),
(121, 'Afganistan', 'uzbecki', 2.9, 'nie'),
(122, 'Chiny', 'kam', 2.9, 'nie'),
(123, 'Chiny', 'buyei', 2.9, 'nie'),
(124, 'Indie', 'nepalski', 2.9, 'nie'),
(125, 'USA', 'mandarynski', 2.9, 'nie'),
(126, 'Chiny', 'mien', 2.8, 'nie'),
(127, 'Indie', 'gondi', 2.7, 'nie'),
(128, 'Indonezja', 'betawi', 2.7, 'nie'),
(129, 'Birma', 'karen', 2.6, 'nie'),
(130, 'Filipiny', 'bikol', 2.5, 'nie'),
(131, 'Filipiny', 'kapampangan', 2.5, 'nie'),
(132, 'Indie', 'sindhi', 2.5, 'nie'),
(133, 'Indie', 'konkani', 2.5, 'nie'),
(134, 'Filipiny', 'pangasinan', 2.4, 'nie'),
(135, 'Kenia', 'somalijski', 2.4, 'nie'),
(136, 'Uganda', 'chiga', 2.4, 'nie'),
(137, 'Uganda', 'teso', 2.4, 'nie'),
(138, 'Etiopia', 'wolaytta', 2.3, 'nie'),
(139, 'Indie', 'dogri', 2.3, 'nie'),
(140, 'Maroko', 'tamazight', 2.3, 'tak'),
(141, 'Poludniowa Afryka', 'tsonga', 2.3, 'tak'),
(142, 'Filipiny', 'maranao', 2.2, 'nie'),
(143, 'Kenia', 'ekegusii', 2.2, 'nie'),
(144, 'Etiopia', 'gurage', 2.1, 'nie'),
(145, 'Etiopia', 'sidamo', 2.1, 'nie'),
(146, 'Indie', 'khandeshi', 2.1, 'nie'),
(147, 'Indonezja', 'sasak', 2.1, 'nie'),
(148, 'Rosja', 'niemiecki', 2.1, 'nie'),
(149, 'Uganda', 'lango', 2.1, 'nie'),
(150, 'USA', 'francuski', 2.1, 'nie'),
(151, 'Algieria', 'tachawit', 2, 'nie'),
(152, 'DRK', 'lingala', 2, 'tak'),
(153, 'Indonezja', 'bataktoba', 2, 'nie'),
(154, 'Irak', 'azerski', 2, 'nie'),
(155, 'Nigeria', 'ijaw', 2, 'nie'),
(156, 'Nigeria', 'tiv', 2, 'nie'),
(157, 'Sudan', 'bedawiyet', 2, 'nie'),
(158, 'Indonezja', 'ambonski', 1.9, 'nie'),
(159, 'Kenia', 'kipsigis', 1.9, 'nie'),
(160, 'Tanzania', 'gogo', 1.9, 'nie'),
(161, 'Afganistan', 'hazaragi', 1.8, 'nie'),
(162, 'Chiny', 'koreanski', 1.8, 'nie'),
(163, 'Etiopia', 'afar', 1.8, 'nie'),
(164, 'Etiopia', 'hadiyya', 1.8, 'nie'),
(165, 'Filipiny', 'tausug', 1.8, 'nie'),
(166, 'Filipiny', 'maguindanao', 1.8, 'nie'),
(167, 'Indie', 'kurukh', 1.8, 'nie'),
(168, 'Chiny', 'hani', 1.7, 'nie'),
(169, 'Indie', 'tulu', 1.7, 'nie'),
(170, 'Kenia', 'kimiiru', 1.7, 'nie'),
(171, 'Nigeria', 'fula', 1.7, 'nie'),
(172, 'Tanzania', 'haya', 1.7, 'nie'),
(173, 'Turcja', 'zazaki', 1.7, 'nie'),
(174, 'Uganda', 'masaaba', 1.7, 'nie'),
(175, 'Etiopia', 'gamo', 1.6, 'nie'),
(176, 'Indonezja', 'makassarese', 1.6, 'nie'),
(177, 'USA', 'tagalog', 1.6, 'nie'),
(178, 'Wietnam', 'tay', 1.6, 'nie'),
(179, 'Afganistan', 'turkmenski', 1.5, 'nie'),
(180, 'Argentyna', 'wloski', 1.5, 'nie'),
(181, 'Brazylia', 'niemiecki', 1.5, 'nie'),
(182, 'Chiny', 'hlai', 1.5, 'nie'),
(183, 'Chiny', 'kazakh', 1.5, 'nie'),
(184, 'DRK', 'luba-katanga', 1.5, 'nie'),
(185, 'Indie', 'meitei', 1.5, 'nie'),
(186, 'Iran', 'arabski', 1.5, 'nie'),
(187, 'Iran', 'beludzi', 1.5, 'nie'),
(188, 'Niemcy', 'turecki', 1.5, 'nie'),
(189, 'Nigeria', 'ibibio', 1.5, 'nie'),
(190, 'Uganda', 'acholi', 1.5, 'nie'),
(191, 'Etiopia', 'gedeo', 1.4, 'nie'),
(192, 'Indie', 'bodo', 1.4, 'nie'),
(193, 'Kenia', 'lubukusu', 1.4, 'nie'),
(194, 'Meksyk', 'nahuatl', 1.4, 'nie'),
(195, 'Rosja', 'czeczenski', 1.4, 'nie'),
(196, 'Tajlandia', 'khmerski', 1.4, 'nie'),
(197, 'Tajlandia', 'yawi', 1.4, 'nie'),
(198, 'USA', 'wietnamski', 1.4, 'nie'),
(199, 'Maroko', 'tarift', 1.3, 'nie'),
(200, 'Pakistan', 'uzbecki', 1.3, 'nie'),
(201, 'Poludniowa Afryka', 'suazi', 1.3, 'tak'),
(202, 'Tanzania', 'makonde', 1.3, 'nie'),
(203, 'Tanzania', 'nyamwezi', 1.3, 'nie'),
(204, 'Chiny', 'bai', 1.2, 'nie'),
(205, 'Filipiny', 'chavacano', 1.2, 'nie'),
(206, 'Indonezja', 'batakdairi', 1.2, 'nie'),
(207, 'Indonezja', 'bataksimalungun', 1.2, 'nie'),
(208, 'Poludniowa Afryka', 'venda', 1.2, 'tak'),
(209, 'Rosja', 'baszkirski', 1.2, 'nie'),
(210, 'Uganda', 'fumbira', 1.2, 'nie'),
(211, 'Etiopia', 'kafa', 1.1, 'nie'),
(212, 'Filipiny', 'kinaray-a', 1.1, 'nie'),
(213, 'Indie', 'khasi', 1.1, 'nie'),
(214, 'Indie', 'mundari', 1.1, 'nie'),
(215, 'Indonezja', 'batakmandailing', 1.1, 'nie'),
(216, 'Poludniowa Afryka', 'ndebele', 1.1, 'tak'),
(217, 'Rosja', 'ukrainski', 1.1, 'nie'),
(218, 'Tanzania', 'hehe', 1.1, 'nie'),
(219, 'Tanzania', 'nyakyusa-ngonde', 1.1, 'nie'),
(220, 'Turcja', 'arabski', 1.1, 'nie'),
(221, 'Uganda', 'lugbara', 1.1, 'nie'),
(222, 'USA', 'koreanski', 1.1, 'nie'),
(223, 'USA', 'niemiecki', 1.1, 'nie'),
(224, 'Wietnam', 'muong', 1.1, 'nie'),
(225, 'Wietnam', 'hmong', 1.1, 'nie'),
(226, 'Wietnam', 'khmerski', 1.1, 'nie'),
(227, 'Argentyna', 'arabski', 1, 'nie'),
(228, 'DRK', 'ngbaka', 1, 'nie'),
(229, 'DRK', 'songe', 1, 'nie'),
(230, 'Egipt', 'beja', 1, 'nie'),
(231, 'Filipiny', 'surigaonon', 1, 'nie'),
(232, 'Indie', 'ho', 1, 'nie'),
(233, 'Indonezja', 'hokkien', 1, 'nie'),
(234, 'Indonezja', 'jambi', 1, 'nie'),
(235, 'Japonia', 'okinawski', 1, 'nie'),
(236, 'Kenia', 'turkana', 1, 'nie'),
(237, 'Nigeria', 'edo', 1, 'nie'),
(238, 'Rosja', 'czuwaski', 1, 'nie'),
(239, 'Tanzania', 'ha', 1, 'nie'),
(240, 'Turcja', 'kabardyjski', 1, 'nie'),
(241, 'Uganda', 'alur', 1, 'nie'),
(242, 'Uganda', 'nyoro', 1, 'nie'),
(243, 'USA', 'rumunski', 1, 'nie'),
(244, 'USA', 'arabski', 1, 'nie'),
(245, 'Wietnam', 'nung', 1, 'nie'),
(246, 'Birma', 'jinpgho', 0.9, 'nie'),
(247, 'DRK', 'nande', 0.9, 'nie'),
(248, 'Francja', 'arabski', 0.9, 'nie'),
(249, 'Hiszpania', 'baskijski', 0.9, 'nie'),
(250, 'Indie', 'kui', 0.9, 'nie'),
(251, 'Indie', 'garo', 0.9, 'nie'),
(252, 'Indie', 'tripuri', 0.9, 'nie'),
(253, 'Indonezja', 'gorontalo', 0.9, 'nie'),
(254, 'Indonezja', 'mongondow', 0.9, 'nie'),
(255, 'Indonezja', 'ngajudayak', 0.9, 'nie'),
(256, 'Kenia', 'maasai', 0.9, 'nie'),
(257, 'Kenia', 'nandi', 0.9, 'nie'),
(258, 'Kenia', 'kigiryama', 0.9, 'nie'),
(259, 'Korea Poludniowa', 'mandarynski', 0.9, 'nie'),
(260, 'Uganda', 'konzo', 0.9, 'nie'),
(261, 'USA', 'rosyjski', 0.9, 'nie'),
(262, 'Wietnam', 'kantonski', 0.9, 'nie'),
(263, 'Argentyna', 'keczua', 0.8, 'nie'),
(264, 'Birma', 'rakhine', 0.8, 'nie'),
(265, 'Birma', 'rohingya', 0.8, 'nie'),
(266, 'Birma', 'chin', 0.8, 'nie'),
(267, 'Birma', 'mon', 0.8, 'nie'),
(268, 'DRK', 'alur', 0.8, 'nie'),
(269, 'DRK', 'tetela', 0.8, 'nie'),
(270, 'Indonezja', 'nias', 0.8, 'nie'),
(271, 'Meksyk', 'maya', 0.8, 'nie'),
(272, 'Niemcy', 'polski', 0.8, 'nie'),
(273, 'Tanzania', 'nyaturu', 0.8, 'nie'),
(274, 'Uganda', 'tooro', 0.8, 'nie'),
(275, 'Wlochy', 'rumunski', 0.8, 'nie'),
(276, 'Chiny', 'hakka', 0.7, 'nie'),
(277, 'Chiny', 'lisu', 0.7, 'nie'),
(278, 'DRK', 'zande', 0.7, 'nie'),
(279, 'DRK', 'yaka', 0.7, 'nie'),
(280, 'DRK', 'yombe', 0.7, 'nie'),
(281, 'DRK', 'shi', 0.7, 'nie'),
(282, 'Francja', 'alzacki', 0.7, 'nie'),
(283, 'Indie', 'mizo', 0.7, 'nie'),
(284, 'Indonezja', 'batakangkola', 0.7, 'nie'),
(285, 'Indonezja', 'minnan', 0.7, 'nie'),
(286, 'Indonezja', 'molukanski', 0.7, 'nie'),
(287, 'Rosja', 'armenski', 0.7, 'nie'),
(288, 'Rosja', 'awarski', 0.7, 'nie'),
(289, 'Sudan', 'fur', 0.7, 'nie'),
(290, 'Tanzania', 'luguru', 0.7, 'nie'),
(291, 'Tanzania', 'bena', 0.7, 'nie'),
(292, 'Tanzania', 'shambala', 0.7, 'nie'),
(293, 'Uganda', 'ng\'akarimojong', 0.7, 'nie'),
(294, 'USA', 'wloski', 0.7, 'nie'),
(295, 'USA', 'portugalski', 0.7, 'nie'),
(296, 'Wietnam', 'taidam', 0.7, 'nie'),
(297, 'Birma', 'pa\'o', 0.6, 'nie'),
(298, 'Chiny', 'dongxiang', 0.6, 'nie'),
(299, 'DRK', 'mangbetu', 0.6, 'nie'),
(300, 'Francja', 'okcytanski', 0.6, 'nie'),
(301, 'Francja', 'portugalski', 0.6, 'nie'),
(302, 'Indie', 'halabi', 0.6, 'nie'),
(303, 'Indie', 'korku', 0.6, 'nie'),
(304, 'Indie', 'mishing', 0.6, 'nie'),
(305, 'Indonezja', 'batakkaro', 0.6, 'nie'),
(306, 'Indonezja', 'uabmeto', 0.6, 'nie'),
(307, 'Kenia', 'pokoot', 0.6, 'nie'),
(308, 'Kenia', 'lulogooli', 0.6, 'nie'),
(309, 'Kenia', 'idakho', 0.6, 'nie'),
(310, 'Niemcy', 'wloski', 0.6, 'nie'),
(311, 'Niemcy', 'arabski', 0.6, 'nie'),
(312, 'Tanzania', 'maasai', 0.6, 'nie'),
(313, 'Tanzania', 'nilamba', 0.6, 'nie'),
(314, 'Tanzania', 'mochi', 0.6, 'nie'),
(315, 'Tanzania', 'yao', 0.6, 'nie'),
(316, 'Uganda', 'gwere', 0.6, 'nie'),
(317, 'Ukraina', 'jidysz', 0.6, 'nie'),
(318, 'USA', 'hindi', 0.6, 'nie'),
(319, 'USA', 'polski', 0.6, 'nie'),
(320, 'Wielka Brytania', 'polski', 0.6, 'nie'),
(321, 'Wielka Brytania', 'walijski', 0.6, 'nie'),
(322, 'Wlochy', 'friulski', 0.6, 'nie'),
(323, 'Afganistan', 'aimaq', 0.5, 'nie'),
(324, 'Birma', 'palaung', 0.5, 'nie'),
(325, 'Birma', 'mandarynski', 0.5, 'nie'),
(326, 'Brazylia', 'hiszpanski', 0.5, 'nie'),
(327, 'Chiny', 'lahu', 0.5, 'nie'),
(328, 'DRK', 'chokwe', 0.5, 'nie'),
(329, 'Filipiny', 'masbateno', 0.5, 'nie'),
(330, 'Filipiny', 'aklanon', 0.5, 'nie'),
(331, 'Francja', 'wloski', 0.5, 'nie'),
(332, 'Francja', 'hiszpanski', 0.5, 'nie'),
(333, 'Indie', 'munda', 0.5, 'nie'),
(334, 'Indonezja', 'bima', 0.5, 'nie'),
(335, 'Indonezja', 'komering', 0.5, 'nie'),
(336, 'Indonezja', 'manggarai', 0.5, 'nie'),
(337, 'Indonezja', 'toraja-sa\'dan', 0.5, 'nie'),
(338, 'Niemcy', 'kurdyjski', 0.5, 'nie'),
(339, 'Niemcy', 'rumunski', 0.5, 'nie'),
(340, 'Rosja', 'kabardyjski', 0.5, 'nie'),
(341, 'Rosja', 'maryjski', 0.5, 'nie'),
(342, 'Rosja', 'dargwa', 0.5, 'nie'),
(343, 'Rosja', 'azerski', 0.5, 'nie'),
(344, 'Rosja', 'ossetic', 0.5, 'nie'),
(345, 'Tajlandia', 'ngaw', 0.5, 'nie'),
(346, 'Tajlandia', 'phuthai', 0.5, 'nie'),
(347, 'Tanzania', 'makhuwa-meetto', 0.5, 'nie'),
(348, 'Tanzania', 'asu', 0.5, 'nie'),
(349, 'Tanzania', 'mwera', 0.5, 'nie'),
(350, 'Tanzania', 'iraqw', 0.5, 'nie'),
(351, 'Turcja', 'azerski', 0.5, 'nie'),
(352, 'Uganda', 'nyole', 0.5, 'nie'),
(353, 'Uganda', 'saamia', 0.5, 'nie'),
(354, 'Uganda', 'aringa', 0.5, 'nie'),
(355, 'Uganda', 'adhola', 0.5, 'nie'),
(356, 'Wlochy', 'arabski', 0.5, 'nie'),
(357, 'Afganistan', 'pashai', 0.4, 'nie'),
(358, 'Argentyna', 'niemiecki', 0.4, 'nie'),
(359, 'Birma', 'tavoyan', 0.4, 'nie'),
(360, 'Birma', 'wa', 0.4, 'nie'),
(361, 'Brazylia', 'japonski', 0.4, 'nie'),
(362, 'Chiny', 'va', 0.4, 'nie'),
(363, 'Chiny', 'sui', 0.4, 'nie'),
(364, 'DRK', 'sanga', 0.4, 'nie'),
(365, 'DRK', 'phende', 0.4, 'nie'),
(366, 'DRK', 'fuliiru', 0.4, 'nie'),
(367, 'DRK', 'lega-shabunda', 0.4, 'nie'),
(368, 'DRK', 'mongo-nkundu', 0.4, 'nie'),
(369, 'DRK', 'mbadja', 0.4, 'nie'),
(370, 'Egipt', 'nobiin', 0.4, 'nie'),
(371, 'Indie', 'karbi', 0.4, 'nie'),
(372, 'Indie', 'koya', 0.4, 'nie'),
(373, 'Indie', 'angielski', 0.4, 'tak'),
(374, 'Indonezja', 'rejang', 0.4, 'nie'),
(375, 'Indonezja', 'tetum', 0.4, 'nie'),
(376, 'Irak', 'perski', 0.4, 'nie'),
(377, 'Irak', 'turkmenski', 0.4, 'nie'),
(378, 'Kanada', 'pendzabski', 0.4, 'nie'),
(379, 'Kanada', 'hiszpanski', 0.4, 'nie'),
(380, 'Kanada', 'niemiecki', 0.4, 'nie'),
(381, 'Kanada', 'wloski', 0.4, 'nie'),
(382, 'Kanada', 'kantonski', 0.4, 'nie'),
(383, 'Kenia', 'chiduruma', 0.4, 'nie'),
(384, 'Meksyk', 'mixtec', 0.4, 'nie'),
(385, 'Meksyk', 'zapotec', 0.4, 'nie'),
(386, 'Meksyk', 'arabski', 0.4, 'nie'),
(387, 'Meksyk', 'tseltal', 0.4, 'nie'),
(388, 'Meksyk', 'angielski', 0.4, 'nie'),
(389, 'Poludniowa Afryka', 'hindi', 0.4, 'nie'),
(390, 'Rosja', 'kumyk', 0.4, 'nie'),
(391, 'Rosja', 'lezgi', 0.4, 'nie'),
(392, 'Sudan', 'masalit', 0.4, 'nie'),
(393, 'Tajlandia', 'karen', 0.4, 'nie'),
(394, 'Tajlandia', 'kuy', 0.4, 'nie'),
(395, 'Tanzania', 'kuria', 0.4, 'nie'),
(396, 'Tanzania', 'langi', 0.4, 'nie'),
(397, 'Tanzania', 'nyambo', 0.4, 'nie'),
(398, 'Tanzania', 'zigula', 0.4, 'nie'),
(399, 'Turcja', 'bulgarski', 0.4, 'nie'),
(400, 'USA', 'japonski', 0.4, 'nie'),
(401, 'USA', 'perski', 0.4, 'nie'),
(402, 'USA', 'urdu', 0.4, 'nie'),
(403, 'USA', 'gudzaracki', 0.4, 'nie'),
(404, 'Wlochy', 'albanski', 0.4, 'nie'),
(405, 'Bangladesz', 'hindi', 0.3, 'nie'),
(406, 'Birma', 'lisu', 0.3, 'nie'),
(407, 'Chiny', 'nashi', 0.3, 'nie'),
(408, 'Chiny', 'qiang', 0.3, 'nie'),
(409, 'Chiny', 'monguor', 0.3, 'nie'),
(410, 'DRK', 'bemba', 0.3, 'nie'),
(411, 'DRK', 'bembe', 0.3, 'nie'),
(412, 'DRK', 'kinyarwanda', 0.3, 'nie'),
(413, 'DRK', 'ngbandi', 0.3, 'nie'),
(414, 'DRK', 'taabwa', 0.3, 'nie'),
(415, 'Egipt', 'domari', 0.3, 'nie'),
(416, 'Filipiny', 'ibanag', 0.3, 'nie'),
(417, 'Francja', 'bretonski', 0.3, 'nie'),
(418, 'Indie', 'ao', 0.3, 'nie'),
(419, 'Indie', 'savara', 0.3, 'nie'),
(420, 'Indonezja', 'bangka', 0.3, 'nie'),
(421, 'Indonezja', 'basasemawa', 0.3, 'nie'),
(422, 'Indonezja', 'gayo', 0.3, 'nie'),
(423, 'Indonezja', 'kantonski', 0.3, 'nie'),
(424, 'Indonezja', 'lewotobi', 0.3, 'nie'),
(425, 'Indonezja', 'muna', 0.3, 'nie'),
(426, 'Indonezja', 'osing', 0.3, 'nie'),
(427, 'Indonezja', 'tae', 0.3, 'nie'),
(428, 'Indonezja', 'tolaki', 0.3, 'nie'),
(429, 'Kanada', 'arabski', 0.3, 'nie'),
(430, 'Kanada', 'tagalog', 0.3, 'nie'),
(431, 'Kenia', 'kiembu', 0.3, 'nie'),
(432, 'Kenia', 'chidigo', 0.3, 'nie'),
(433, 'Kenia', 'olunyole', 0.3, 'nie'),
(434, 'Kenia', 'oluwanga', 0.3, 'nie'),
(435, 'Kenia', 'borana', 0.3, 'nie'),
(436, 'Kenia', 'dawida', 0.3, 'nie'),
(437, 'Kenia', 'markweeta', 0.3, 'nie'),
(438, 'Kenia', 'nyala', 0.3, 'nie'),
(439, 'Kenia', 'kuria', 0.3, 'nie'),
(440, 'Kenia', 'lukabaras', 0.3, 'nie'),
(441, 'Meksyk', 'tsotsil', 0.3, 'nie'),
(442, 'Niemcy', 'grecki', 0.3, 'nie'),
(443, 'Niemcy', 'serbsko-chorwacki', 0.3, 'nie'),
(444, 'Niemcy', 'angielski', 0.3, 'nie'),
(445, 'Poludniowa Afryka', 'tamilski', 0.3, 'nie'),
(446, 'Rosja', 'inguski', 0.3, 'nie'),
(447, 'Rosja', 'karaczajsko-balkarski', 0.3, 'nie'),
(448, 'Sudan', 'kanuri', 0.3, 'nie'),
(449, 'Tanzania', 'machame', 0.3, 'nie'),
(450, 'Tanzania', 'vunjo', 0.3, 'nie'),
(451, 'Tanzania', 'mambwe-lungu', 0.3, 'nie'),
(452, 'Tanzania', 'gudzaracki', 0.3, 'nie'),
(453, 'Turcja', 'adygejski', 0.3, 'nie'),
(454, 'Uganda', 'suahili', 0.3, 'tak'),
(455, 'Uganda', 'ma\'di', 0.3, 'nie'),
(456, 'Uganda', 'kupsapiiny', 0.3, 'nie'),
(457, 'Uganda', 'kumam', 0.3, 'nie'),
(458, 'Ukraina', 'rumunski', 0.3, 'nie'),
(459, 'Ukraina', 'bialoruski', 0.3, 'nie'),
(460, 'Ukraina', 'tatarski', 0.3, 'nie'),
(461, 'USA', 'grecki', 0.3, 'nie'),
(462, 'USA', 'serbsko-chorwacki', 0.3, 'nie'),
(463, 'Wielka Brytania', 'urdu', 0.3, 'nie'),
(464, 'Wietnam', 'zhuang', 0.3, 'nie'),
(465, 'Wietnam', 'taidon', 0.3, 'nie'),
(466, 'Wlochy', 'hiszpanski', 0.3, 'nie'),
(467, 'Afganistan', 'beludzi', 0.2, 'nie'),
(468, 'Afganistan', 'brahui', 0.2, 'nie'),
(469, 'Argentyna', 'guarani', 0.2, 'nie'),
(470, 'Argentyna', 'jidysz', 0.2, 'nie'),
(471, 'Argentyna', 'katalonski', 0.2, 'nie'),
(472, 'Birma', 'akha', 0.2, 'nie'),
(473, 'Birma', 'lahu', 0.2, 'nie'),
(474, 'Birma', 'kayah', 0.2, 'nie'),
(475, 'Chiny', 'mulam', 0.2, 'nie'),
(476, 'Chiny', 'xibe', 0.2, 'nie'),
(477, 'Chiny', 'kirgiski', 0.2, 'nie'),
(478, 'DRK', 'logo', 0.2, 'nie'),
(479, 'DRK', 'kanyok', 0.2, 'nie'),
(480, 'DRK', 'budu', 0.2, 'nie'),
(481, 'DRK', 'kele', 0.2, 'nie'),
(482, 'DRK', 'ruund', 0.2, 'nie'),
(483, 'DRK', 'tembo', 0.2, 'nie'),
(484, 'Francja', 'niemiecki', 0.2, 'nie'),
(485, 'Francja', 'polski', 0.2, 'nie'),
(486, 'Francja', 'turecki', 0.2, 'nie'),
(487, 'Indie', 'konyak', 0.2, 'nie'),
(488, 'Indie', 'kharia', 0.2, 'nie'),
(489, 'Indie', 'malto', 0.2, 'nie'),
(490, 'Indie', 'nissi', 0.2, 'nie'),
(491, 'Indie', 'adi', 0.2, 'nie'),
(492, 'Indie', 'thado', 0.2, 'nie'),
(493, 'Indie', 'lotha', 0.2, 'nie'),
(494, 'Indie', 'coorgi', 0.2, 'nie'),
(495, 'Indie', 'rabha', 0.2, 'nie'),
(496, 'Irak', 'gurani', 0.2, 'nie'),
(497, 'Irak', 'asyryjski', 0.2, 'nie'),
(498, 'Japonia', 'mandarynski', 0.2, 'nie'),
(499, 'Kanada', 'mandarynski', 0.2, 'nie'),
(500, 'Kanada', 'portugalski', 0.2, 'nie'),
(501, 'Kanada', 'polski', 0.2, 'nie'),
(502, 'Kanada', 'urdu', 0.2, 'nie'),
(503, 'Kanada', 'perski', 0.2, 'nie'),
(504, 'Kanada', 'rosyjski', 0.2, 'nie'),
(505, 'Kenia', 'sabaot', 0.2, 'nie'),
(506, 'Kenia', 'kitharaka', 0.2, 'nie'),
(507, 'Kenia', 'olumarachi', 0.2, 'nie'),
(508, 'Kenia', 'olumarama', 0.2, 'nie'),
(509, 'Meksyk', 'otomi', 0.2, 'nie'),
(510, 'Meksyk', 'totonac', 0.2, 'nie'),
(511, 'Meksyk', 'mazatec', 0.2, 'nie'),
(512, 'Meksyk', 'ch\'ol', 0.2, 'nie'),
(513, 'Niemcy', 'rosyjski', 0.2, 'nie'),
(514, 'Niemcy', 'bulgarski', 0.2, 'nie'),
(515, 'Niemcy', 'albanski', 0.2, 'nie'),
(516, 'Niemcy', 'wegierski', 0.2, 'nie'),
(517, 'Niemcy', 'hiszpanski', 0.2, 'nie'),
(518, 'Nigeria', 'arabski', 0.2, 'nie'),
(519, 'Nigeria', 'bacama', 0.2, 'nie'),
(520, 'Nigeria', 'bata', 0.2, 'nie'),
(521, 'Pakistan', 'rohingya', 0.2, 'nie'),
(522, 'Pakistan', 'arabski', 0.2, 'nie'),
(523, 'Rosja', 'komi', 0.2, 'nie'),
(524, 'Rosja', 'buriacki', 0.2, 'nie'),
(525, 'Rosja', 'tuwinski', 0.2, 'nie'),
(526, 'Sudan', 'berta', 0.2, 'nie'),
(527, 'Sudan', 'zaghawa', 0.2, 'nie'),
(528, 'Tanzania', 'nyiha', 0.2, 'nie'),
(529, 'Tanzania', 'kagulu', 0.2, 'nie'),
(530, 'Tanzania', 'ngingo', 0.2, 'nie'),
(531, 'Tanzania', 'jita', 0.2, 'nie'),
(532, 'Tanzania', 'fipa', 0.2, 'nie'),
(533, 'Tanzania', 'sumbwa', 0.2, 'nie'),
(534, 'Tanzania', 'pogolo', 0.2, 'nie'),
(535, 'Tanzania', 'ngoni', 0.2, 'nie'),
(536, 'Tanzania', 'safwa', 0.2, 'nie'),
(537, 'Tanzania', 'shubi', 0.2, 'nie'),
(538, 'Tanzania', 'hangaza', 0.2, 'nie'),
(539, 'Tanzania', 'matengo', 0.2, 'nie'),
(540, 'Tanzania', 'ndali', 0.2, 'nie'),
(541, 'Uganda', 'kakwa', 0.2, 'nie'),
(542, 'Ukraina', 'bulgarski', 0.2, 'nie'),
(543, 'Ukraina', 'wegierski', 0.2, 'nie'),
(544, 'USA', 'armenski', 0.2, 'nie'),
(545, 'USA', 'hebrajski', 0.2, 'nie'),
(546, 'USA', 'khmerski', 0.2, 'nie'),
(547, 'USA', 'hmong', 0.2, 'nie'),
(548, 'USA', 'navajo', 0.2, 'nie'),
(549, 'USA', 'thai', 0.2, 'nie'),
(550, 'USA', 'jidysz', 0.2, 'nie'),
(551, 'Wielka Brytania', 'pendzabski', 0.2, 'nie'),
(552, 'Wielka Brytania', 'bengalski', 0.2, 'nie'),
(553, 'Wielka Brytania', 'gudzaracki', 0.2, 'nie'),
(554, 'Wielka Brytania', 'arabski', 0.2, 'nie'),
(555, 'Wietnam', 'jarai', 0.2, 'nie'),
(556, 'Wietnam', 'phuthai', 0.2, 'nie'),
(557, 'Wietnam', 'rade', 0.2, 'nie'),
(558, 'Wietnam', 'kimmun', 0.2, 'nie'),
(559, 'Wietnam', 'caolan', 0.2, 'nie'),
(560, 'Wietnam', 'koho', 0.2, 'nie'),
(561, 'Wietnam', 'cham', 0.2, 'nie'),
(562, 'Wietnam', 'bahnar', 0.2, 'nie'),
(563, 'Wlochy', 'mandarynski', 0.2, 'nie'),
(564, 'Argentyna', 'mapuche', 0.1, 'nie'),
(565, 'Birma', 'kayan', 0.1, 'nie'),
(566, 'Birma', 'khun', 0.1, 'nie'),
(567, 'Chiny', 'jingpo', 0.1, 'nie'),
(568, 'Chiny', 'daur', 0.1, 'nie'),
(569, 'Chiny', 'salar', 0.1, 'nie'),
(570, 'Chiny', 'blang', 0.1, 'nie'),
(571, 'Chiny', 'maonan', 0.1, 'nie'),
(572, 'Chiny', 'tujia', 0.1, 'nie'),
(573, 'DRK', 'mayogo', 0.1, 'nie'),
(574, 'DRK', 'ngiti', 0.1, 'nie'),
(575, 'Filipiny', 'yakan', 0.1, 'nie'),
(576, 'Indie', 'tangkhul', 0.1, 'nie'),
(577, 'Indie', 'kisan', 0.1, 'nie'),
(578, 'Indie', 'angami', 0.1, 'nie'),
(579, 'Indie', 'phom', 0.1, 'nie'),
(580, 'Indie', 'kolami', 0.1, 'nie'),
(581, 'Indie', 'kuvi', 0.1, 'nie'),
(582, 'Indie', 'dimasa', 0.1, 'nie'),
(583, 'Indie', 'ladakhi', 0.1, 'nie'),
(584, 'Indie', 'sema', 0.1, 'nie'),
(585, 'Irak', 'chaldejski', 0.1, 'nie'),
(586, 'Kanada', 'wietnamski', 0.1, 'nie'),
(587, 'Kanada', 'koreanski', 0.1, 'nie'),
(588, 'Kanada', 'tamilski', 0.1, 'nie'),
(589, 'Kanada', 'ukrainski', 0.1, 'nie'),
(590, 'Kanada', 'holenderski', 0.1, 'nie'),
(591, 'Kanada', 'grecki', 0.1, 'nie'),
(592, 'Kanada', 'gudzaracki', 0.1, 'nie'),
(593, 'Kanada', 'hindi', 0.1, 'nie'),
(594, 'Kanada', 'rumunski', 0.1, 'nie'),
(595, 'Kanada', 'kri', 0.1, 'nie'),
(596, 'Kenia', 'suba', 0.1, 'nie'),
(597, 'Kenia', 'olushisa', 0.1, 'nie'),
(598, 'Kenia', 'olukhayo', 0.1, 'nie'),
(599, 'Kenia', 'olusamia', 0.1, 'nie'),
(600, 'Kenia', 'olutsotso', 0.1, 'nie'),
(601, 'Kenia', 'lutachoni', 0.1, 'nie'),
(602, 'Kenia', 'suahili', 0.1, 'tak'),
(603, 'Kenia', 'sagalla', 0.1, 'nie'),
(604, 'Korea Poludniowa', 'angielski', 0.1, 'nie'),
(605, 'Korea Poludniowa', 'wietnamski', 0.1, 'nie'),
(606, 'Meksyk', 'huastec', 0.1, 'nie'),
(607, 'Meksyk', 'chinantec', 0.1, 'nie'),
(608, 'Meksyk', 'mixe', 0.1, 'nie'),
(609, 'Meksyk', 'mazahua', 0.1, 'nie'),
(610, 'Meksyk', 'purepecha', 0.1, 'nie'),
(611, 'Meksyk', 'tlapanec', 0.1, 'nie'),
(612, 'Niemcy', 'ukrainski', 0.1, 'nie'),
(613, 'Niemcy', 'francuski', 0.1, 'nie'),
(614, 'Niemcy', 'mandarynski', 0.1, 'nie'),
(615, 'Niemcy', 'macedonski', 0.1, 'nie'),
(616, 'Nigeria', 'izere', 0.1, 'nie'),
(617, 'Polska', 'kaszubski', 0.1, 'nie'),
(618, 'Polska', 'angielski', 0.1, 'nie'),
(619, 'Polska', 'niemiecki', 0.1, 'nie'),
(620, 'Rosja', 'lak', 0.1, 'nie'),
(621, 'Rosja', 'altajski', 0.1, 'nie'),
(622, 'Rosja', 'romski', 0.1, 'nie'),
(623, 'Rosja', 'tabasaran', 0.1, 'nie'),
(624, 'Rosja', 'adygejski', 0.1, 'nie'),
(625, 'Sudan', 'ama', 0.1, 'nie'),
(626, 'Tanzania', 'kinga', 0.1, 'nie'),
(627, 'Tanzania', 'luo', 0.1, 'nie'),
(628, 'Tanzania', 'zinza', 0.1, 'nie'),
(629, 'Tanzania', 'ngulu', 0.1, 'nie'),
(630, 'Tanzania', 'kwaya', 0.1, 'nie'),
(631, 'Tanzania', 'suba', 0.1, 'nie'),
(632, 'Tanzania', 'kerewe', 0.1, 'nie'),
(633, 'Tanzania', 'ndendule', 0.1, 'nie'),
(634, 'Tanzania', 'zanaki', 0.1, 'nie'),
(635, 'Turcja', 'tatarski', 0.1, 'nie'),
(636, 'Uganda', 'pokoot', 0.1, 'nie'),
(637, 'Uganda', 'talinga-bwisi', 0.1, 'nie'),
(638, 'Uganda', 'kenye', 0.1, 'nie'),
(639, 'Uganda', 'gungu', 0.1, 'nie'),
(640, 'Uganda', 'thur', 0.1, 'nie'),
(641, 'Ukraina', 'polski', 0.1, 'nie'),
(642, 'Ukraina', 'armenski', 0.1, 'nie'),
(643, 'Ukraina', 'urum', 0.1, 'nie'),
(644, 'USA', 'laotanski', 0.1, 'nie'),
(645, 'USA', 'wegierski', 0.1, 'nie'),
(646, 'Wielka Brytania', 'portugalski', 0.1, 'nie'),
(647, 'Wielka Brytania', 'hiszpanski', 0.1, 'nie'),
(648, 'Wielka Brytania', 'tamilski', 0.1, 'nie'),
(649, 'Wietnam', 'roglai', 0.1, 'nie'),
(650, 'Wietnam', 'sedang', 0.1, 'nie'),
(651, 'Wietnam', 'taidaeng', 0.1, 'nie'),
(652, 'Wlochy', 'rosyjski', 0.1, 'nie'),
(653, 'Wlochy', 'ukrainski', 0.1, 'nie'),
(654, 'Wlochy', 'francuski', 0.1, 'nie'),
(655, 'Wlochy', 'okcytanski', 0.1, 'nie'),
(656, 'Wlochy', 'serbsko-chorwacki', 0.1, 'nie');

--
-- Indeksy dla zrzutów tabel
--

--
-- Indeksy dla tabeli `jezyki`
--
ALTER TABLE `jezyki`
  ADD PRIMARY KEY (`Jezyk`);

--
-- Indeksy dla tabeli `panstwa`
--
ALTER TABLE `panstwa`
  ADD PRIMARY KEY (`Panstwo`);

--
-- Indeksy dla tabeli `uzytkownicy`
--
ALTER TABLE `uzytkownicy`
  ADD PRIMARY KEY (`Id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
